/*********************************************************************/
/* Four Functions for working with Flag Variables                    */
/*  Copyright (c) 1999 Gene Myers                                    */
/*                                                                   */
/*********************************************************************/
#include <math.h> /* for pow() */

#define BIN     2
typedef unsigned short int FLAG;


FLAG set_bit( int Bit, FLAG FlagVar )
{
	return ( FlagVar |  FLAG(pow( BIN,Bit )) );
}

FLAG clear_bit( int Bit, FLAG FlagVar )
{
	return ( FlagVar & ~(FLAG(pow( BIN,Bit )))  );
}

FLAG toggle_bit( int Bit, FLAG FlagVar )
{
	return ( FlagVar ^ (FLAG(pow( BIN,Bit )))  );
}

FLAG test_bit( int Bit, FLAG FlagVar )
{
	if ( FlagVar & FLAG(pow( BIN,Bit )) )
		return 1;
	else
		return 0;
}
