/* main.c - a program to test the dbugger() function */
/* In linux cc -o debug_test main.c dbugger.c        */

#include <stdio.h>
#include <string.h>
#include "dbugger.h"

int main( int, char ** );
void test1( void );
void test2( void );

/* Required globals for dbugger()  */

int    DEBUG_LEVEL  = 9; 
long   DEBUG_MAX    = 10000L;
char * DEBUG_FILE   = "/tmp/test.log";
char * program_name = "test.c";


int main( int argc, char *argv[] )
{
int i;
char * function_name = "main";
	dbugger(TRIVIAL, "Start of %s", function_name);
	dbugger(IMPORTANT, "First from main");
	for(i=0; i<100; i++)
	{
		test1();
		test2();
	}
	dbugger(2); /* this will produce undefined behavior */
	dbugger(8, "debug_max = %d", DEBUG_MAX);
	dbugger(TRIVIAL, "End of %s", function_name);
return 0;
}

void test1(void)
{
char * function_name = "test1";
	dbugger(TRIVIAL, "Start of %s", function_name);
	dbugger(EMERGENCY, "%s %s %s", "this","is","emergency lev");
	dbugger(TRIVIAL, "End of %s", function_name);
}

void test2(void)
{
char * function_name = "test2";
	dbugger(TRIVIAL, "Start of %s", function_name);
	dbugger(INFORMATION, "%s-%s-%s", "this","is","information lev");
	dbugger(TRIVIAL, "End of %s", function_name);
}
