/* dbugger.c  - contains the public function dbugger()              */
/* Intended as a library utility function for Linux development     */
/* written by waterhose 					    */

#include <stdio.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/timeb.h>
#include <sys/types.h>
#include <time.h>
#include <unistd.h>
#include <varargs.h>

#include "dbugger.h"

char *get_now_time(void);
void roll_over_log(void);

/* These globals are declared in the main source file */
extern int  DEBUG_LEVEL;        /* Runtime value - Defined at top of Main source file.*/
extern long DEBUG_MAX;          /* Runtime value - Defined at top of Main source file.*/
extern char *DEBUG_FILE;        /* Runtime value - Defined at top of Main source file.*/
extern char *program_name;      /* Runtime value - Defined at top of Main source file.*/

void dbugger( level, va_alist )
int level;
va_dcl
{
	va_list args;
	FILE *dbugfile;
	char *format;
	char buffer[512]; 
	int i, attempts;


	if (DEBUG_LEVEL >= level) /* Don't do debug messages with a lower priority */
	{                         /* than the program's debugging level.           */
		va_start( args );
			sprintf(buffer, "\n%s|%d|%s|", get_now_time(), getpid(), program_name);
			i = strlen(buffer);
			format = va_arg(args, char*);
			vsprintf(buffer + i, format, args);
		va_end( args );

		for (attempts = 0; attempts < 5; attempts++)
		{
			if (DEBUG_FILE[0])
			{
				if ((dbugfile = fopen(DEBUG_FILE, "a")) != NULL)
				{
					fprintf(dbugfile, "%s\n", buffer);
					fflush(dbugfile); fclose(dbugfile);
					chmod(DEBUG_FILE, S_IRWXU | S_IRWXG | S_IRWXO);
					attempts = 5;
				}
				else
					usleep(100000L); /* Wait, someones writing it now. */
			}
			else
				/* failure, try to print it where someone can find it */
				/* This too may fail..                                */
				fprintf(stderr, "%s\n", buffer);
		}
		roll_over_log();
	}
} /* end dbugger */



char *get_now_time( void )
{
	struct timeb tb;
	struct tm *tmp;
	static char time_string[32];


	ftime(&tb);
	tmp = localtime(&tb.time);
	strftime(time_string, sizeof(time_string), "%h %d %H:%M:%S", tmp);
	sprintf(&time_string[strlen(time_string)], ".%03d", tb.millitm);

return(time_string);
} /* end get_now_time */



void roll_over_log( void )
{
	struct stat file_stat;
	char backup_file[55];


	/* A 0 limit size means don't limit file */
	if (!DEBUG_MAX)	return;
	
	/* A NULL file name. */
	if (!DEBUG_FILE[0])	return;	

	/* Oops. This is bad. No file. */
	if (stat(DEBUG_FILE, &file_stat))	return;

	/* File still smaller than limit */
	if (file_stat.st_size < DEBUG_MAX)	return;

	sprintf(backup_file, "%s.bak", DEBUG_FILE);

	/* remove the old backup if it exists */
	unlink(backup_file);

	/* chmod ugo+rwx the new log file */
	if (!rename(DEBUG_FILE, backup_file))
		chmod(backup_file, S_IRWXU | S_IRWXG | S_IRWXO);

} /* end roll_over_log */

