
#include <stdio.h>
#include <signal.h>

#include "dbugger.h"

void ignore_all_signals( void );

void ignore_all_signals(void)
{
     struct sigaction sigact;

     sigact.sa_handler = SIG_IGN;
     sigemptyset( &sigact.sa_mask );
     sigact.sa_flags = 0;

     if (sigaction(SIGHUP, &sigact, (void *) NULL))    /* hangup */
          dbugger(SERIOUS, "Ignore Sigaction - SIGHUP failed");

     if (sigaction(SIGINT, &sigact, (void *) NULL))    /* interrupt */
          dbugger(SERIOUS, "Ignore Sigaction - SIGINT failed");

     if (sigaction(SIGQUIT, &sigact, (void *) NULL))   /* quit */
          dbugger(SERIOUS, "Ignore Sigaction - SIGQUIT failed");

     if (sigaction(SIGILL, &sigact, (void *) NULL))    /* illegal instruction */
          dbugger(SERIOUS, "Ignore Sigaction - SIGILL failed");

     if (sigaction(SIGTRAP, &sigact, (void *) NULL))   /* trace trap */
          dbugger(SERIOUS, "Ignore Sigaction - SIGTRAP failed");

     if (sigaction(SIGABRT, &sigact, (void *) NULL))   /* used by abort */
          dbugger(SERIOUS, "Ignore Sigaction - SIGABRT failed");

/* *** linux is unfamiliar with SIGEMT instruction
     if (sigaction(SIGEMT, &sigact, (void *) NULL))    
          dbugger(SERIOUS, "Ignore Sigaction - SIGEMT failed");
*** */

     if (sigaction(SIGFPE, &sigact, (void *) NULL))    /* floating pt exception */
          dbugger(SERIOUS, "Ignore Sigaction - SIGFPE failed");

     /* SIGKILL can not be caught or ignored */

     if (sigaction(SIGBUS, &sigact, (void *) NULL))    /* bus error */
          dbugger(SERIOUS, "Ignore Sigaction - SIGBUS failed");

     if (sigaction(SIGSEGV, &sigact, (void *) NULL))   /* segmentation violation */
          dbugger(SERIOUS, "Ignore Sigaction - SIGSEGV failed");

/* *** linux is unfamiliar with SIGSYS, bad arg to sys call
     if (sigaction(SIGSYS, &sigact, (void *) NULL))    
          dbugger(SERIOUS, "Ignore Sigaction - SIGSYS failed");
*** */

     if (sigaction(SIGPIPE, &sigact, (void *) NULL))   /* write pipe w/no 1 read */
          dbugger(SERIOUS, "Ignore Sigaction - SIGPIPE failed");

     if (sigaction(SIGALRM, &sigact, (void *) NULL))   /* alarm clock */
          dbugger(SERIOUS, "Ignore Sigaction - SIGALRM failed");

     if (sigaction(SIGTERM, &sigact, (void *) NULL))   /* sw termination */
          dbugger(SERIOUS, "Ignore Sigaction - SIGTERM failed");

     if (sigaction(SIGUSR1, &sigact, (void *) NULL))   /* user signal */
          dbugger(SERIOUS, "Ignore Sigaction - SIGUSR1 failed");

     if (sigaction(SIGUSR2, &sigact, (void *) NULL))   /* user signal */
          dbugger(SERIOUS, "Ignore Sigaction - SIGUSR2 failed");

     if (sigaction(SIGCHLD, &sigact, (void *) NULL))   /* synonym for SIGCLD */
          dbugger(SERIOUS, "Ignore Sigaction - SIGCHLD failed");

     if (sigaction(SIGPWR, &sigact, (void *) NULL))    /* power fail */
          dbugger(SERIOUS, "Ignore Sigaction - SIGPWR failed");

     if (sigaction(SIGWINCH, &sigact, (void *) NULL))  /* window change */
          dbugger(SERIOUS, "Ignore Sigaction - SIGWINCH failed");

     if (sigaction(SIGPOLL, &sigact, (void *) NULL))   /* select event pending */
          dbugger(SERIOUS, "Ignore Sigaction - SIGPOLL failed");

     /* SIGSTOP can not be caught or ignored */

     if (sigaction(SIGTSTP, &sigact, (void *) NULL))   /* stop from from tty */
          dbugger(SERIOUS, "Ignore Sigaction - SIGTSTP failed");

     if (sigaction(SIGCONT, &sigact, (void *) NULL))   /* cont a stopped proc */
          dbugger(SERIOUS, "Ignore Sigaction - SIGCONT failed");

     if (sigaction(SIGTTIN, &sigact, (void *) NULL))   /* bg tty read attempt */
          dbugger(SERIOUS, "Ignore Sigaction - SIGTTIN failed");

     if (sigaction(SIGTTOU, &sigact, (void *) NULL))   /* bg tty write attempt */
          dbugger(SERIOUS, "Ignore Sigaction - SIGTTOU failed");

     if (sigaction(SIGVTALRM, &sigact, (void *) NULL)) /* virtual timer */
          dbugger(SERIOUS, "Ignore Sigaction - SIGVTALRM failed");

     if (sigaction(SIGPROF, &sigact, (void *) NULL))   /* profile alarm */
          dbugger(SERIOUS, "Ignore Sigaction - SIGPROF failed");

} /* end ignore_all_signals */


